#!/bin/bash

STEAM_USER=LorenDB
STEAM_ALSO_CACHE_WINDOWS=0
DOWNLOAD_GAME_SCRIPT_PATH="/home/loren/.local/bin/download-steam-game.sh"

if [[ "$#" -ne 1 ]]; then
        echo "Requires a single argument"
        exit 1
fi

GAMES_LIST=$(cat $1)
for game_info in $GAMES_LIST; do
        game_name=$(echo $game_info | cut -d ',' -f 1)
        game_id=$(echo $game_info | cut -d ',' -f 2)
        game_windows_only=$(echo $game_info | cut -d ',' -f 3)

        if [[ "$game_windows_only" -eq 1 ]]; then
                $DOWNLOAD_GAME_SCRIPT_PATH -u $STEAM_USER -n $game_name -i $game_id -w
        else
                $DOWNLOAD_GAME_SCRIPT_PATH -u $STEAM_USER -n $game_name -i $game_id
        fi
done